﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    /// <summary>
    /// Summary description for EligibilityImporterTests
    /// </summary>
    [TestClass]
    public class EligibilityImporterTests
    {
       
        private EligibilityInfoImporter _cut;
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new EligibilityInfoImporter();
        }
        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 

        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void ContainerAndListAreNotNull_Returns_False_With_Null_List()
        {
            MilitaryServiceEligibility serviceEligibilityInstance = new MilitaryServiceEligibility();
            serviceEligibilityInstance.militaryServiceEpisodes = null;
            var actual = _cut.ContainerAndListAreNotNull(serviceEligibilityInstance, serviceEligibilityInstance.militaryServiceEpisodes);
            Assert.AreEqual(false, actual);
        }

        [TestMethod]
        public void ContainerAndListAreNotNull_Returns_True_If_Parameter_sAre_Not_Null()
        {
            MilitaryServiceEligibility serviceEligibilityInstance = new MilitaryServiceEligibility();
            serviceEligibilityInstance.militaryServiceEpisodes =  new MilitaryServiceEpisodeEligibilityData[1];
            var actual = _cut.ContainerAndListAreNotNull(serviceEligibilityInstance, serviceEligibilityInstance.militaryServiceEpisodes);
            Assert.AreEqual(true, actual);
        }

        [TestMethod()]
        
        public void GetMilitaryServiceEpisodes_Returns_An_Empty_List_When_No_Service_Episodes_Exist()
        {
            VeteranStatus actual = _cut.GetVeteranStatus(null);
            Assert.IsNotNull(actual);
        }

               
        [TestMethod()]
        [ExpectedException(typeof(ArgumentNullException))]
        public void GetMilitaryServiceEligibilityInfo_Throws_Exception_When_Null_Episode_Argument_Is_Passed()
        {
            _cut.GetMilitaryServiceEligibilityInfo("", null);
        }

        [TestMethod()]
        [ExpectedException(typeof(ArgumentNullException))]
        public void CreateRegistrantServiceEpisodeEntry_Throws_Exception_When_Null_Episode_Argument_Is_Passed()
        {
            REGISTRANT_SERVICE_EPISODE actual = _cut.CreateRegistrantServiceEpisodeEntry(45, null);
        }         
    }
}
